function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 52);

T(1) = params(15)/100;
T(2) = (1+params(14)/100)/(1+params(16)/100)/(1+T(1))^(-params(6));
T(3) = (1+T(1))^(-params(6))*T(2)*y(100)/y(33);
T(4) = 1+T(1);
T(5) = 1.01^(1-params(6))-1;
T(6) = T(4)^(1-params(6));
T(7) = T(2)*T(6);
T(8) = y(25)-params(7)*y(1)/T(4);
T(9) = T(8)^(1-params(6))/(1-params(6));
T(10) = exp((params(6)-1)*y(26)^(1+params(35))/(1+params(35)));
T(11) = (1-params(6))*T(2)*params(7)*y(95)/T(6);
T(12) = y(97)^2;
T(13) = T(3)*y(102)*y(99)*T(12);
T(14) = y(26)^params(35);
T(15) = 1/(1-1/params(5));
T(16) = y(104)^params(5);
T(17) = y(40)^(params(5)*params(13));
T(18) = T(16)/T(17);
T(19) = y(40)^(params(13)*(params(5)-1));
T(20) = T(19)*y(103);
T(21) = T(16)/T(20);
T(22) = y(8)^params(13);
T(23) = T(22)/y(41);
T(24) = y(41)^params(5);
T(25) = y(8)^(params(5)*params(13));
T(26) = (y(44)*y(50))^params(2);
T(27) = y(2)/T(4);
T(28) = T(27)^(1-params(2));
T(29) = 1/(1-1/params(4));
T(30) = T(29)*y(54);
T(31) = y(103)^params(4);
T(32) = y(40)^(params(4)*params(12));
T(33) = T(31)/T(32);
T(34) = y(103)^(params(4)-1);
T(35) = y(40)^(params(12)*(params(4)-1));
T(36) = T(34)/T(35);
T(37) = y(8)^params(12);
T(38) = T(37)/y(40);
T(39) = y(40)^params(4);
T(40) = y(8)^(params(4)*params(12));
T(41) = y(39)/(steady_state(18));
T(42) = y(7)/(steady_state(18));
T(43) = y(40)/(steady_state(19));
T(44) = y(54)/(steady_state(33));
T(45) = y(54)/y(13);
T(46) = params(28)/T(4);
T(47) = y(81)/T(4);
T(48) = y(69)^2;
T(49) = 1+y(69)*params(31)+y(83)*T(48)/2;
T(50) = T(4)*y(25)/y(1);
T(51) = T(4)*y(30)/y(3);
T(52) = T(4)*y(42)/y(9);

end
